#ifndef DBASECONTROLWIN_H
    #define DBASECONTROLWIN_H
 
    #include "DEventosBase.h"
    #include <commctrl.h>

    namespace DWL {

	    //! Clase base para los controles normales
        class DBaseControlWin : public DBaseWnd {
	      public : /////////////////////////// Miembros publicos

										    //! Constructor.
										    /*! Constructor.
												    \fn			DBaseControlWin(void);
												    \return		No devuelve nada.
										    */
										    DBaseControlWin(void);

										    //! Destructor.
										    /*! Destructor.
												    \fn		   ~DBaseControlWin(void);
												    \return		No devuelve nada.
										    */
		    virtual					       ~DBaseControlWin(void);

									   	    //! Esqueleto para los mensajes del control.
										    /*! Esta funcin es el esqueleto para los mensajes del control.
												    \fn			virtual LRESULT CALLBACK GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
												    \param[in]	uMsg	: Mensaje.
												    \param[in]	wParam	: Parametro1.
												    \param[in]	lParam	: Parametro2.
												    \return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
										    */
	        virtual LRESULT CALLBACK	    GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);

										    //! Funcin que destruye este control.
										    /*!	Esta funcion destruye este control.
												    \fn			const BOOL Destruir(void);
												    \return		Devuelve TRUE si la operacin se completo, FALSE en caso contrario.
										    */
	        virtual BOOL                    Destruir(void);

	      protected : ////////////////////////// Miembros protegidos

										    //! Funcin que conecta este control con un dialogo.
										    /*!	Esta funcin que conecta este control con un dialogo.
												    \fn			void ConectarControl(const UINT nID, DBaseWnd *Padre);
                                                    \param[in]  nID     ID del control.
                                                    \param[in]  nPadre  Clase DBaseWnd que hace de padre para el control.
		                                            \return		No devuelve nada.
										    */
	        void	        			   _ConectarControl(const UINT nID, DBaseWnd *nPadre);

										    //! Esqueleto inicial que enlaza esta clase con el control.
										    /*! Esta funcin es el esqueleto inicial que enlaza esta clase con el control.
												    \fn			static LRESULT CALLBACK _GestorMensajes(HWND HandleVentana, UINT uMsg, WPARAM wParam, LPARAM lParam);
												    \param[in]	HandleVentana	: Identificador de ventana.
												    \param[in]	uMsg			: Mensaje.
												    \param[in]	wParam			: Parametro1.
												    \param[in]	lParam			: Parametro2.
												    \return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
										    */
	        static LRESULT CALLBACK	       _GestorMensajes(HWND HandleVentana, UINT uMsg, WPARAM wParam, LPARAM lParam);

										    //! WindowProcedure Orignal del control estndar
	        WNDPROC                        _GestorMensajesOriginal;
	    };                                  //
	    ////////////////////////////////////// Fin DWLControl
    };

#endif